package peak.can;

/**
 * The MutableInteger class wraps a value of the primitive type int in an object. An object of type Integer contains a single field whose type is int.
 * This class is used because Java.Lang.Integer objects are defined as Imutable. Yet, we need to maintain object reference when it's passed to the JNI library using.
 * So, we defined a simple Class which extends Java.Lang.Object to resolve the problematic.
 *
 * @version 1.0
 * @LastChange 15/12/2009
 * @author Urban Jonathan
 *
 * @Copyright (C) 1999-2009  PEAK-System Technik GmbH, Darmstadt
 * more Info at http://www.peak-system.com
 */
public class MutableInteger
{

    /**
     * Constructor
     * @param value int value
     */
    public MutableInteger(int value)
    {
        this.value = value;
    }

    /**
     * Constructor parsing the string argument as a integer
     * @param value integer as string
     */
    public MutableInteger(String value)
    {
        this.value = Integer.parseInt(value);
    }

    /**
     * Gets integer value
     * @return integer value
     */
    public int getValue()
    {
        return value;
    }

    /**
     * Sets integer value
     * @param integer value
     */
    public void setValue(int value)
    {
        this.value = value;
    }
    public int value;

    /**
     * Overrides toString() to display int value
     * @return
     */
    @Override
    public String toString()
    {
        return Integer.toString(value);
    }
}
