package peak.can;

import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANTimestamp;

/**
 * The TableDataRow class is a structure to store all provided info by a CAN Message
 *
 * @version 1.0
 * @LastChange 15/12/2009
 * @author Urban Jonathan
 *
 * @Copyright (C) 1999-2009  PEAK-System Technik GmbH, Darmstadt
 * more Info at http://www.peak-system.com
 */
public class TableDataRow
{

    //Private fields
    private TPCANTimestamp rcvTime;
    private int counter;
    private TPCANMsg message;

    /**
     * Gets number of times the CAN Message was readed
     * @return number of times
     */
    public int getCounter()
    {
        return counter;
    }

    /**
     * Sets number of times the CAN Message was readed
     * @param counter
     */
    public void setCounter(int counter)
    {
        this.counter = counter;
    }

    /**
     * Gets wrapped TPCANMsg
     * @return wrapped TPCANMsg
     */
    public TPCANMsg getMessage()
    {
        return message;
    }

    /**
     * Sets wrapped TPCANMsg
     * @param wrapped TPCANMsg
     */
    public void setMessage(TPCANMsg message)
    {
        this.message = message;
    }

    /**
     * Gets wrapped TPCANTimestamp
     * @return wrapped TPCANTimestamp
     */
    public TPCANTimestamp getRcvTime()
    {
        return rcvTime;
    }

    /**
     * Sets wrapped TPCANTimestamp
     * @param wrapped TPCANTimestamp
     */
    public void setRcvTime(TPCANTimestamp rcvTime)
    {
        this.rcvTime = rcvTime;
    }
}
