package peak.can;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import peak.can.basic.TPCANBaudrate;
import peak.can.basic.PCANBasic;
import peak.can.basic.RcvEventDispatcher;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMode;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANParameter;
import peak.can.basic.TPCANParameterValue;
import peak.can.basic.TPCANStatus;
import peak.can.basic.TPCANType;

public class Application extends javax.swing.JFrame
{

    public Application()
    {
        // Initialization
        initComponents();

        // Crate New instance of PCANBasic
        pcanBasic = new PCANBasic();
        // JNI Initialization
        pcanBasic.initializeAPI();

        // Init TimeStamp Grid Column
        columnTimeStamp = new TableColumn();
        columnTimeStamp.setMinWidth(100);
        columnTimeStamp.setMaxWidth(100);
        columnTimeStamp.setWidth(100);
        columnTimeStamp.setResizable(false);
        columnTimeStamp.setHeaderValue("Rcv Time");
        columnTimeStamp.setModelIndex(5);
        jTableMessage.getColumnModel().removeColumn(jTableMessage.getColumnModel().getColumn(jTableMessage.getColumnModel().getColumnCount() - 1));

        // Create Collection for connected Channels
        connectedChannelCollection = new Vector<ChannelItem>();
        jComboBoxConnectedChannel.setModel(new DefaultComboBoxModel(connectedChannelCollection));

        // Create and start Table Message Thread
        canReadThread = new CANReadThread(pcanBasic, connectedChannelCollection, receivedData);
        canReadThread.start();

        // Create and start Table Message Thread
        tableMessageThread = new TableMessageThread(jTableMessage, receivedData);
        tableMessageThread.start();

        // UI Update
        UpdateUIButtons();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupReadMode = new javax.swing.ButtonGroup();
        buttonGroupONOFF = new javax.swing.ButtonGroup();
        buttonGroupOpenClose = new javax.swing.ButtonGroup();
        buttonGroupFilter = new javax.swing.ButtonGroup();
        jPanelHardware = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxChannel = new javax.swing.JComboBox();
        jComboBoxBaudrate = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxPort = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxInterrupt = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jComboBoxHardwareType = new javax.swing.JComboBox();
        jButtonConnect = new javax.swing.JButton();
        jPanelNewConnection = new javax.swing.JPanel();
        jLabel61 = new javax.swing.JLabel();
        jComboBoxConnectedChannel = new javax.swing.JComboBox();
        jButtonRelease = new javax.swing.JButton();
        jLabel62 = new javax.swing.JLabel();
        jButtonPause = new javax.swing.JButton();
        jButtonStart = new javax.swing.JButton();
        jPanelInfo = new javax.swing.JPanel();
        jScrollPaneInfo = new javax.swing.JScrollPane();
        jTexteAreaInfo = new javax.swing.JTextArea();
        jPanelRead = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableMessage = new javax.swing.JTable();
        jCheckBoxTimeStamp = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        jRadioButtonTimer = new javax.swing.JRadioButton();
        jRadioButtonEvent = new javax.swing.JRadioButton();
        jPanelWrite = new javax.swing.JPanel();
        jTextFieldWriteID = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jSpinnerLength = new javax.swing.JSpinner();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jTextFieldData0 = new javax.swing.JTextField();
        jButtonWrite = new javax.swing.JButton();
        jCheckBoxWriteExtended = new javax.swing.JCheckBox();
        jCheckBoxWriteRemote = new javax.swing.JCheckBox();
        jTextFieldData1 = new javax.swing.JTextField();
        jTextFieldData2 = new javax.swing.JTextField();
        jTextFieldData3 = new javax.swing.JTextField();
        jTextFieldData4 = new javax.swing.JTextField();
        jTextFieldData5 = new javax.swing.JTextField();
        jTextFieldData6 = new javax.swing.JTextField();
        jTextFieldData7 = new javax.swing.JTextField();
        jPanelFilter = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jTextFieldIDFrom = new javax.swing.JTextField();
        jTextFieldIDTo = new javax.swing.JTextField();
        jButtonFilterSet = new javax.swing.JButton();
        jCheckBoxFilterExtended = new javax.swing.JCheckBox();
        jRadioFilterOpen = new javax.swing.JRadioButton();
        jRadioFilterClose = new javax.swing.JRadioButton();
        jRadioFilterCustom = new javax.swing.JRadioButton();
        jButtonFilterQuery = new javax.swing.JButton();
        jPanelConfiguration = new javax.swing.JPanel();
        jLayeredPaneConfiguration = new javax.swing.JLayeredPane();
        jPanelDeviceNumber = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jSpinnerDeviceNumber = new javax.swing.JSpinner();
        jPanelLogPath = new javax.swing.JPanel();
        jLabel16 = new javax.swing.JLabel();
        jButtonBrowse = new javax.swing.JButton();
        jScrollPanePath = new javax.swing.JScrollPane();
        jTextAreaPath = new javax.swing.JTextArea();
        jPanelLogConfigure = new javax.swing.JPanel();
        jCheckBoxRead = new javax.swing.JCheckBox();
        jCheckBoxEntry = new javax.swing.JCheckBox();
        jCheckBoxLeave = new javax.swing.JCheckBox();
        jCheckBoxWrite = new javax.swing.JCheckBox();
        jCheckBoxParameter = new javax.swing.JCheckBox();
        jPanelActivation = new javax.swing.JPanel();
        jLabel13 = new javax.swing.JLabel();
        jRadioButtonOFF = new javax.swing.JRadioButton();
        jRadioButtonON = new javax.swing.JRadioButton();
        jComboBoxParameter = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jButtonGet = new javax.swing.JButton();
        jButtonSet = new javax.swing.JButton();
        jScrollPaneParameterDescription = new javax.swing.JScrollPane();
        jTextAreaParameterDescription = new javax.swing.JTextArea();
        jLabel17 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        jButtonClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("I CAN Do It! - Basic");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanelHardware.setBorder(javax.swing.BorderFactory.createTitledBorder("New Connections"));

        jLabel1.setText("Channel:");

        jLabel2.setText("Baud Rate:");

        jComboBoxChannel.setMaximumRowCount(15);
        jComboBoxChannel.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANHandle.initializableChannels()));
        jComboBoxChannel.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxChannel.setPreferredSize(new java.awt.Dimension(128, 20));
        jComboBoxChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxChannelActionPerformed(evt);
            }
        });

        jComboBoxBaudrate.setMaximumRowCount(15);
        jComboBoxBaudrate.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANBaudrate.values()));
        jComboBoxBaudrate.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxBaudrate.setPreferredSize(new java.awt.Dimension(128, 20));

        jLabel3.setText("Port:");

        jComboBoxPort.setMaximumRowCount(15);
        jComboBoxPort.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "100", "120", "140", "200", "220", "240", "260", "278", "280", "2A0", "2C0", "2E0", "2E8", "2F8", "300", "320", "340", "360", "378", "380", "3BC", "3E0", "3E8", "3F8", " " }));
        jComboBoxPort.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxPort.setPreferredSize(new java.awt.Dimension(128, 20));

        jLabel4.setText("Int:");

        jComboBoxInterrupt.setMaximumRowCount(15);
        jComboBoxInterrupt.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "3", "4", "5", "7", "9", "10", "11", "12", "15" }));
        jComboBoxInterrupt.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxInterrupt.setPreferredSize(new java.awt.Dimension(128, 20));

        jLabel5.setText("Hardware Type:");

        jComboBoxHardwareType.setMaximumRowCount(15);
        jComboBoxHardwareType.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANDevice.values()));
        jComboBoxHardwareType.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxHardwareType.setPreferredSize(new java.awt.Dimension(128, 20));

        jButtonConnect.setText("Connect");
        jButtonConnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonConnectActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelHardwareLayout = new javax.swing.GroupLayout(jPanelHardware);
        jPanelHardware.setLayout(jPanelHardwareLayout);
        jPanelHardwareLayout.setHorizontalGroup(
            jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelHardwareLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jComboBoxChannel, javax.swing.GroupLayout.Alignment.TRAILING, 0, 120, Short.MAX_VALUE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel5)
                    .addComponent(jComboBoxHardwareType, 0, 120, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelHardwareLayout.createSequentialGroup()
                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel3)
                            .addComponent(jComboBoxPort, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel4)
                            .addComponent(jComboBoxInterrupt, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jLabel2)
                    .addGroup(jPanelHardwareLayout.createSequentialGroup()
                        .addComponent(jComboBoxBaudrate, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonConnect)))
                .addContainerGap())
        );
        jPanelHardwareLayout.setVerticalGroup(
            jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelHardwareLayout.createSequentialGroup()
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxBaudrate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxChannel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonConnect))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4)
                    .addComponent(jLabel5))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelHardwareLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxInterrupt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jComboBoxHardwareType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelNewConnection.setBorder(javax.swing.BorderFactory.createTitledBorder("Connected Channels"));

        jLabel61.setText("Channel Handle:");

        jComboBoxConnectedChannel.setMaximumRowCount(15);
        jComboBoxConnectedChannel.setMinimumSize(new java.awt.Dimension(128, 18));
        jComboBoxConnectedChannel.setPreferredSize(new java.awt.Dimension(128, 20));
        jComboBoxConnectedChannel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectedChannelActionPerformed(evt);
            }
        });

        jButtonRelease.setText("Release");
        jButtonRelease.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReleaseActionPerformed(evt);
            }
        });

        jLabel62.setText("Working Channel:");

        jButtonPause.setText("Pause");
        jButtonPause.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartOrPauseActionPerformed(evt);
            }
        });

        jButtonStart.setText("Start");
        jButtonStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStartOrPauseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelNewConnectionLayout = new javax.swing.GroupLayout(jPanelNewConnection);
        jPanelNewConnection.setLayout(jPanelNewConnectionLayout);
        jPanelNewConnectionLayout.setHorizontalGroup(
            jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel61)
                    .addComponent(jLabel62)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelNewConnectionLayout.createSequentialGroup()
                        .addComponent(jComboBoxConnectedChannel, 0, 196, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonRelease))
                    .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                        .addComponent(jButtonPause)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonStart)))
                .addContainerGap())
        );
        jPanelNewConnectionLayout.setVerticalGroup(
            jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelNewConnectionLayout.createSequentialGroup()
                .addComponent(jLabel61)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jComboBoxConnectedChannel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonRelease))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel62)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelNewConnectionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonPause)
                    .addComponent(jButtonStart))
                .addContainerGap(8, Short.MAX_VALUE))
        );

        jPanelInfo.setBorder(javax.swing.BorderFactory.createTitledBorder("Information"));

        jTexteAreaInfo.setColumns(20);
        jTexteAreaInfo.setEditable(false);
        jTexteAreaInfo.setLineWrap(true);
        jTexteAreaInfo.setRows(5);
        jTexteAreaInfo.setText("Select a Hardware and a configuration for it. Then click \"Initialize\" button");
        jScrollPaneInfo.setViewportView(jTexteAreaInfo);

        javax.swing.GroupLayout jPanelInfoLayout = new javax.swing.GroupLayout(jPanelInfo);
        jPanelInfo.setLayout(jPanelInfoLayout);
        jPanelInfoLayout.setHorizontalGroup(
            jPanelInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelInfoLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPaneInfo, javax.swing.GroupLayout.DEFAULT_SIZE, 656, Short.MAX_VALUE)
                .addContainerGap())
        );
        jPanelInfoLayout.setVerticalGroup(
            jPanelInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelInfoLayout.createSequentialGroup()
                .addComponent(jScrollPaneInfo, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelRead.setBorder(javax.swing.BorderFactory.createTitledBorder("Read Messages"));

        jTableMessage.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Type", "ID", "Length", "Data", "Count", "Rcv Time"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableMessage.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.setViewportView(jTableMessage);

        jCheckBoxTimeStamp.setText("Show Time Stamp");
        jCheckBoxTimeStamp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxTimeStampActionPerformed(evt);
            }
        });

        jLabel10.setText("Read Method:");

        buttonGroupReadMode.add(jRadioButtonTimer);
        jRadioButtonTimer.setSelected(true);
        jRadioButtonTimer.setText("By Timer");
        jRadioButtonTimer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonTimerActionPerformed(evt);
            }
        });

        buttonGroupReadMode.add(jRadioButtonEvent);
        jRadioButtonEvent.setText("By Event");
        jRadioButtonEvent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonEventActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelReadLayout = new javax.swing.GroupLayout(jPanelRead);
        jPanelRead.setLayout(jPanelReadLayout);
        jPanelReadLayout.setHorizontalGroup(
            jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelReadLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 656, Short.MAX_VALUE)
                    .addGroup(jPanelReadLayout.createSequentialGroup()
                        .addComponent(jLabel10)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jRadioButtonTimer)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonEvent)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 337, Short.MAX_VALUE)
                        .addComponent(jCheckBoxTimeStamp)))
                .addContainerGap())
        );
        jPanelReadLayout.setVerticalGroup(
            jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelReadLayout.createSequentialGroup()
                .addGroup(jPanelReadLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel10)
                    .addComponent(jRadioButtonTimer)
                    .addComponent(jRadioButtonEvent)
                    .addComponent(jCheckBoxTimeStamp))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        jPanelWrite.setBorder(javax.swing.BorderFactory.createTitledBorder("Write Messages"));

        jTextFieldWriteID.setText("0");
        jTextFieldWriteID.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldWriteIDFocusLost(evt);
            }
        });
        jTextFieldWriteID.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldWriteIDKeyTyped(evt);
            }
        });

        jLabel7.setText("ID (Hex):");

        jSpinnerLength.setModel(new javax.swing.SpinnerNumberModel(8, 0, 8, 1));
        jSpinnerLength.setValue(8);
        jSpinnerLength.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jSpinnerLengthStateChanged(evt);
            }
        });

        jLabel8.setText("Length:");

        jLabel9.setText("Data (0..7):");

        jTextFieldData0.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData0.setText("00");
        jTextFieldData0.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData0FocusLost(evt);
            }
        });
        jTextFieldData0.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData0KeyTyped(evt);
            }
        });

        jButtonWrite.setText("Write Message");
        jButtonWrite.setEnabled(false);
        jButtonWrite.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWriteActionPerformed(evt);
            }
        });

        jCheckBoxWriteExtended.setText("Extended Frame");
        jCheckBoxWriteExtended.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jCheckBoxWriteExtended.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteExtendedActionPerformed(evt);
            }
        });

        jCheckBoxWriteRemote.setText("RTR");
        jCheckBoxWriteRemote.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxWriteRemoteActionPerformed(evt);
            }
        });

        jTextFieldData1.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData1.setText("00");
        jTextFieldData1.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData1FocusLost(evt);
            }
        });
        jTextFieldData1.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData1KeyTyped(evt);
            }
        });

        jTextFieldData2.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData2.setText("00");
        jTextFieldData2.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData2FocusLost(evt);
            }
        });
        jTextFieldData2.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData2KeyTyped(evt);
            }
        });

        jTextFieldData3.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData3.setText("00");
        jTextFieldData3.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData3FocusLost(evt);
            }
        });
        jTextFieldData3.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData3KeyTyped(evt);
            }
        });

        jTextFieldData4.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData4.setText("00");
        jTextFieldData4.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData4FocusLost(evt);
            }
        });
        jTextFieldData4.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData4KeyTyped(evt);
            }
        });

        jTextFieldData5.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData5.setText("00");
        jTextFieldData5.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData5FocusLost(evt);
            }
        });
        jTextFieldData5.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData5KeyTyped(evt);
            }
        });

        jTextFieldData6.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData6.setText("00");
        jTextFieldData6.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData6FocusLost(evt);
            }
        });
        jTextFieldData6.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData6KeyTyped(evt);
            }
        });

        jTextFieldData7.setHorizontalAlignment(javax.swing.JTextField.CENTER);
        jTextFieldData7.setText("00");
        jTextFieldData7.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldData7FocusLost(evt);
            }
        });
        jTextFieldData7.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldData7KeyTyped(evt);
            }
        });

        javax.swing.GroupLayout jPanelWriteLayout = new javax.swing.GroupLayout(jPanelWrite);
        jPanelWrite.setLayout(jPanelWriteLayout);
        jPanelWriteLayout.setHorizontalGroup(
            jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelWriteLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addComponent(jLabel7)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldWriteID, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSpinnerLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData0, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData1, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData2, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData3, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData4, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData5, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData6, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldData7, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(37, 37, 37)
                        .addComponent(jButtonWrite, javax.swing.GroupLayout.PREFERRED_SIZE, 123, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanelWriteLayout.createSequentialGroup()
                        .addComponent(jCheckBoxWriteExtended)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jCheckBoxWriteRemote)))
                .addContainerGap())
        );
        jPanelWriteLayout.setVerticalGroup(
            jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelWriteLayout.createSequentialGroup()
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(jTextFieldWriteID, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jSpinnerLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData0, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8)
                    .addComponent(jLabel9)
                    .addComponent(jTextFieldData1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldData2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonWrite))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanelWriteLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxWriteExtended)
                    .addComponent(jCheckBoxWriteRemote))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelFilter.setBorder(javax.swing.BorderFactory.createTitledBorder("Message Filter"));

        jLabel6.setText("From:");

        jLabel19.setText("To:");

        jTextFieldIDFrom.setColumns(3);
        jTextFieldIDFrom.setText("0");
        jTextFieldIDFrom.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldIDFromFocusLost(evt);
            }
        });
        jTextFieldIDFrom.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldIDFromKeyTyped(evt);
            }
        });

        jTextFieldIDTo.setText("0");
        jTextFieldIDTo.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldIDToFocusLost(evt);
            }
        });
        jTextFieldIDTo.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                jTextFieldIDToKeyTyped(evt);
            }
        });

        jButtonFilterSet.setText("Set");
        jButtonFilterSet.setEnabled(false);
        jButtonFilterSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFilterSetActionPerformed(evt);
            }
        });

        jCheckBoxFilterExtended.setText("Extended");
        jCheckBoxFilterExtended.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxFilterExtendedActionPerformed(evt);
            }
        });

        buttonGroupFilter.add(jRadioFilterOpen);
        jRadioFilterOpen.setSelected(true);
        jRadioFilterOpen.setText("Open");

        buttonGroupFilter.add(jRadioFilterClose);
        jRadioFilterClose.setText("Close");

        buttonGroupFilter.add(jRadioFilterCustom);
        jRadioFilterCustom.setText("Custom (expand)");

        jButtonFilterQuery.setText("Query");
        jButtonFilterQuery.setEnabled(false);
        jButtonFilterQuery.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFilterQueryActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelFilterLayout = new javax.swing.GroupLayout(jPanelFilter);
        jPanelFilter.setLayout(jPanelFilterLayout);
        jPanelFilterLayout.setHorizontalGroup(
            jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilterLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jCheckBoxFilterExtended)
                .addGap(16, 16, 16)
                .addComponent(jRadioFilterOpen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioFilterClose)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioFilterCustom)
                .addGap(10, 10, 10)
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldIDFrom, javax.swing.GroupLayout.PREFERRED_SIZE, 66, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jLabel19)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldIDTo, javax.swing.GroupLayout.PREFERRED_SIZE, 67, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonFilterSet, javax.swing.GroupLayout.PREFERRED_SIZE, 65, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(11, 11, 11)
                .addComponent(jButtonFilterQuery)
                .addContainerGap())
        );
        jPanelFilterLayout.setVerticalGroup(
            jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelFilterLayout.createSequentialGroup()
                .addGroup(jPanelFilterLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioFilterOpen)
                    .addComponent(jRadioFilterClose)
                    .addComponent(jRadioFilterCustom)
                    .addComponent(jLabel6)
                    .addComponent(jTextFieldIDFrom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldIDTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel19)
                    .addComponent(jCheckBoxFilterExtended)
                    .addComponent(jButtonFilterSet)
                    .addComponent(jButtonFilterQuery))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanelConfiguration.setBorder(javax.swing.BorderFactory.createTitledBorder("Configuration"));

        jLabel14.setText("Device Number:");

        jSpinnerDeviceNumber.setModel(new javax.swing.SpinnerNumberModel(1, 1, 429496729, 1));

        javax.swing.GroupLayout jPanelDeviceNumberLayout = new javax.swing.GroupLayout(jPanelDeviceNumber);
        jPanelDeviceNumber.setLayout(jPanelDeviceNumberLayout);
        jPanelDeviceNumberLayout.setHorizontalGroup(
            jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDeviceNumberLayout.createSequentialGroup()
                .addComponent(jLabel14)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSpinnerDeviceNumber, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(41, Short.MAX_VALUE))
        );
        jPanelDeviceNumberLayout.setVerticalGroup(
            jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelDeviceNumberLayout.createSequentialGroup()
                .addGroup(jPanelDeviceNumberLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel14)
                    .addComponent(jSpinnerDeviceNumber, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(100, Short.MAX_VALUE))
        );

        jPanelDeviceNumber.setBounds(0, 0, 210, 120);
        jLayeredPaneConfiguration.add(jPanelDeviceNumber, javax.swing.JLayeredPane.DEFAULT_LAYER);

        jLabel16.setText("Log File Path:");

        jButtonBrowse.setText("Browse");
        jButtonBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseActionPerformed(evt);
            }
        });

        jTextAreaPath.setColumns(20);
        jTextAreaPath.setEditable(false);
        jTextAreaPath.setLineWrap(true);
        jTextAreaPath.setRows(5);
        jScrollPanePath.setViewportView(jTextAreaPath);

        javax.swing.GroupLayout jPanelLogPathLayout = new javax.swing.GroupLayout(jPanelLogPath);
        jPanelLogPath.setLayout(jPanelLogPathLayout);
        jPanelLogPathLayout.setHorizontalGroup(
            jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogPathLayout.createSequentialGroup()
                .addGroup(jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel16)
                    .addComponent(jScrollPanePath, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(80, 80, 80))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLogPathLayout.createSequentialGroup()
                .addComponent(jButtonBrowse, javax.swing.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                .addGap(88, 88, 88))
        );
        jPanelLogPathLayout.setVerticalGroup(
            jPanelLogPathLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelLogPathLayout.createSequentialGroup()
                .addComponent(jLabel16)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPanePath, javax.swing.GroupLayout.PREFERRED_SIZE, 84, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButtonBrowse)
                .addGap(12, 12, 12))
        );

        jPanelLogPath.setBounds(0, 0, 230, 150);
        jLayeredPaneConfiguration.add(jPanelLogPath, javax.swing.JLayeredPane.DEFAULT_LAYER);

        jCheckBoxRead.setText("Read");

        jCheckBoxEntry.setText("Entry");

        jCheckBoxLeave.setText("Leave");

        jCheckBoxWrite.setText("Write");

        jCheckBoxParameter.setText("Parameter");

        javax.swing.GroupLayout jPanelLogConfigureLayout = new javax.swing.GroupLayout(jPanelLogConfigure);
        jPanelLogConfigure.setLayout(jPanelLogConfigureLayout);
        jPanelLogConfigureLayout.setHorizontalGroup(
            jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                        .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxLeave)
                            .addComponent(jCheckBoxEntry))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBoxRead)
                            .addComponent(jCheckBoxWrite)))
                    .addComponent(jCheckBoxParameter))
                .addContainerGap(64, Short.MAX_VALUE))
        );
        jPanelLogConfigureLayout.setVerticalGroup(
            jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelLogConfigureLayout.createSequentialGroup()
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxLeave)
                    .addComponent(jCheckBoxWrite))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelLogConfigureLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxEntry)
                    .addComponent(jCheckBoxRead))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxParameter)
                .addContainerGap(51, Short.MAX_VALUE))
        );

        jPanelLogConfigure.setBounds(0, 0, 170, 120);
        jLayeredPaneConfiguration.add(jPanelLogConfigure, javax.swing.JLayeredPane.DEFAULT_LAYER);

        jLabel13.setText("Activation:");

        buttonGroupONOFF.add(jRadioButtonOFF);
        jRadioButtonOFF.setText("OFF");

        buttonGroupONOFF.add(jRadioButtonON);
        jRadioButtonON.setSelected(true);
        jRadioButtonON.setText("ON");

        javax.swing.GroupLayout jPanelActivationLayout = new javax.swing.GroupLayout(jPanelActivation);
        jPanelActivation.setLayout(jPanelActivationLayout);
        jPanelActivationLayout.setHorizontalGroup(
            jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelActivationLayout.createSequentialGroup()
                .addComponent(jLabel13)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jRadioButtonON)
                .addGap(2, 2, 2)
                .addComponent(jRadioButtonOFF)
                .addContainerGap(24, Short.MAX_VALUE))
        );
        jPanelActivationLayout.setVerticalGroup(
            jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelActivationLayout.createSequentialGroup()
                .addGroup(jPanelActivationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel13)
                    .addComponent(jRadioButtonON)
                    .addComponent(jRadioButtonOFF))
                .addContainerGap(97, Short.MAX_VALUE))
        );

        jPanelActivation.setBounds(0, 0, 170, 120);
        jLayeredPaneConfiguration.add(jPanelActivation, javax.swing.JLayeredPane.DEFAULT_LAYER);

        jComboBoxParameter.setMaximumRowCount(16);
        jComboBoxParameter.setModel(new DefaultComboBoxModel(peak.can.basic.TPCANParameter.customizableParameters()));
        jComboBoxParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxParameterActionPerformed(evt);
            }
        });

        jLabel11.setText("Parameter:");

        jButtonGet.setText("Get");
        jButtonGet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGetActionPerformed(evt);
            }
        });

        jButtonSet.setText("Set");
        jButtonSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetActionPerformed(evt);
            }
        });

        jTextAreaParameterDescription.setColumns(20);
        jTextAreaParameterDescription.setLineWrap(true);
        jTextAreaParameterDescription.setRows(5);
        jTextAreaParameterDescription.setWrapStyleWord(true);
        jScrollPaneParameterDescription.setViewportView(jTextAreaParameterDescription);

        jLabel17.setText("Parameter Value(s):");

        jLabel18.setText("Function:");

        javax.swing.GroupLayout jPanelConfigurationLayout = new javax.swing.GroupLayout(jPanelConfiguration);
        jPanelConfiguration.setLayout(jPanelConfigurationLayout);
        jPanelConfigurationLayout.setHorizontalGroup(
            jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPaneParameterDescription, javax.swing.GroupLayout.DEFAULT_SIZE, 316, Short.MAX_VALUE)
                    .addComponent(jLabel11)
                    .addComponent(jComboBoxParameter, 0, 316, Short.MAX_VALUE))
                .addGap(18, 18, 18)
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel17)
                    .addComponent(jLayeredPaneConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, 208, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addComponent(jButtonSet)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jButtonGet))
                    .addComponent(jLabel18))
                .addContainerGap())
        );
        jPanelConfigurationLayout.setVerticalGroup(
            jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel11)
                    .addComponent(jLabel17)
                    .addComponent(jLabel18))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanelConfigurationLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jButtonGet)
                        .addComponent(jButtonSet))
                    .addGroup(jPanelConfigurationLayout.createSequentialGroup()
                        .addComponent(jComboBoxParameter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPaneParameterDescription, javax.swing.GroupLayout.PREFERRED_SIZE, 118, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLayeredPaneConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, 144, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanelHardware, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanelNewConnection, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addComponent(jPanelRead, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelFilter, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelWrite, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelConfiguration, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanelInfo, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jButtonClose, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelNewConnection, 0, 127, Short.MAX_VALUE)
                    .addComponent(jPanelHardware, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelFilter, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelRead, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelWrite, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelConfiguration, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanelInfo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonClose)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxChannelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jComboBoxChannelActionPerformed
    {//GEN-HEADEREND:event_jComboBoxChannelActionPerformed
        boolean isNonPnP = false;

        // Check selected Channel is a NON-PNP device
        switch ((TPCANHandle) jComboBoxChannel.getSelectedItem())
        {
            case PCAN_DNGBUS1:
            case PCAN_ISABUS1:
            case PCAN_ISABUS2:
            case PCAN_ISABUS3:
            case PCAN_ISABUS4:
            case PCAN_ISABUS5:
            case PCAN_ISABUS6:
            case PCAN_ISABUS7:
            case PCAN_ISABUS8:
                isNonPnP = true;
                break;
        }

        // Update UI depending NON-PNP device
        jComboBoxHardwareType.setEnabled(isNonPnP);
        jComboBoxPort.setEnabled(isNonPnP);
        jComboBoxInterrupt.setEnabled(isNonPnP);
    }//GEN-LAST:event_jComboBoxChannelActionPerformed

    private void jButtonConnectActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonConnectActionPerformed
    {//GEN-HEADEREND:event_jButtonConnectActionPerformed
        TPCANStatus res;
        ChannelItem item;

        // According to the active parameters/hardware, we
        // use one of the two possible "Init" PCANLight functions.
        // One is for Plug-and-Play hardware, and the other for
        // Non-P&P.
        if (jComboBoxPort.isEnabled())
            // Non-P&P Hardware
            res = pcanBasic.Initialize(getSelectedChannel(), getSelectedBaudrate(), getSelectedHardwareType(), getSelectedPort(), getSelectedInterrupt());
        else
            // P&P Hardware
            res = pcanBasic.Initialize(getSelectedChannel(), getSelectedBaudrate(), TPCANType.PCAN_TYPE_NONE, 0, (short) 0);

        // The Hardware was successfully initiated
        if (res == TPCANStatus.PCAN_ERROR_OK)
        {
            if (jComboBoxPort.isEnabled())
                // Non-P&P Hardware
                item = new ChannelItem(getSelectedChannel(), getSelectedHardwareType());
            else
                // P&P Hardware
                item = new ChannelItem(getSelectedChannel());
            connectedChannelCollection.add(item);
            if ((connectedChannelCollection.size() > 1) && (!connectedChannelCollection.contains(MarkAllChannelItem.getInstance())))
                connectedChannelCollection.add(MarkAllChannelItem.getInstance());
            jComboBoxConnectedChannel.setSelectedItem(item);
            showInfo(item.getHandle().toString() + " Successfully initialized", false);
        }
        else
            getError(res);

    }//GEN-LAST:event_jButtonConnectActionPerformed

    private void jCheckBoxTimeStampActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxTimeStampActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxTimeStampActionPerformed
        // Configure canReadThread to call the right CAN function
        if (canReadThread != null)
            canReadThread.setReadTimeStamp(jCheckBoxTimeStamp.isSelected());

        // Add or Remove column
        if (jCheckBoxTimeStamp.isSelected())
            jTableMessage.getColumnModel().addColumn(columnTimeStamp);
        else
            jTableMessage.getColumnModel().removeColumn(columnTimeStamp);
    }//GEN-LAST:event_jCheckBoxTimeStampActionPerformed

    private void jComboBoxConnectedChannelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jComboBoxConnectedChannelActionPerformed
    {//GEN-HEADEREND:event_jComboBoxConnectedChannelActionPerformed
        //Updates UI
        UpdateUIButtons();
    }//GEN-LAST:event_jComboBoxConnectedChannelActionPerformed

    private void jButtonReleaseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonReleaseActionPerformed
    {//GEN-HEADEREND:event_jButtonReleaseActionPerformed
        TPCANStatus status;

        // Get Selected Item
        ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

        // If simple ChannelItem
        if (item != MarkAllChannelItem.getInstance())
        {
            // Unitializes current Channel
            status = uninitialize(item);
            if (status == TPCANStatus.PCAN_ERROR_OK)
            {
                // Remove item in collection
                connectedChannelCollection.remove(item);
                // Remove MarkAllChannelItem if need be
                if (connectedChannelCollection.size() == 2)
                    connectedChannelCollection.remove(MarkAllChannelItem.getInstance());
                showInfo(item.getHandle().toString() + " Successfully unitialized", false);
            }
        }
        // If MarkAllChannelItem
        else
        {
            // Unitializes each Channel
            for (ChannelItem subItem : connectedChannelCollection)
            {
                if (subItem != MarkAllChannelItem.getInstance())
                {
                    status = uninitialize(subItem);
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                        return;
                }

            }
            // Remove all items in collection
            connectedChannelCollection.removeAllElements();
            showInfo("All Successfully unitialized", false);
        }

        // Update UI
        if (connectedChannelCollection.size() > 0)
            jComboBoxConnectedChannel.setSelectedIndex(0);
        else
            jComboBoxConnectedChannel.removeAllItems();
        jComboBoxConnectedChannel.updateUI();
        UpdateUIButtons();
    }//GEN-LAST:event_jButtonReleaseActionPerformed

    private void jRadioButtonTimerActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonTimerActionPerformed
    {//GEN-HEADEREND:event_jRadioButtonTimerActionPerformed
        changeReadMode(jRadioButtonTimer.isSelected());
    }//GEN-LAST:event_jRadioButtonTimerActionPerformed

    private void jRadioButtonEventActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonEventActionPerformed
    {//GEN-HEADEREND:event_jRadioButtonEventActionPerformed
        changeReadMode(jRadioButtonTimer.isSelected());
    }//GEN-LAST:event_jRadioButtonEventActionPerformed

    private void jButtonStartOrPauseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonStartOrPauseActionPerformed
    {//GEN-HEADEREND:event_jButtonStartOrPauseActionPerformed
        // Get targeted state
        boolean working = (evt.getSource() == jButtonStart) ? true : false;

        // Get Selected Item
        ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

        // If simple ChannelItem
        if (item != MarkAllChannelItem.getInstance())
            changeChannelState(item, working);
        // If MarkAllChannelItem, process all items
        else
            for (ChannelItem subItem : connectedChannelCollection)
            {
                if (subItem != MarkAllChannelItem.getInstance())
                    changeChannelState(subItem, working);
            }

        // Update UI
        jComboBoxConnectedChannel.updateUI();
        UpdateUIButtons();
    }//GEN-LAST:event_jButtonStartOrPauseActionPerformed

    private void jComboBoxParameterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jComboBoxParameterActionPerformed
    {//GEN-HEADEREND:event_jComboBoxParameterActionPerformed
        // Get selected Parameter
        TPCANParameter selectedParameter = (TPCANParameter) jComboBoxParameter.getSelectedItem();

        // Update selected Parameter description
        jTextAreaParameterDescription.setText(TPCANParameter.getParameterDescription(selectedParameter));

        // Hide all parameter UI
        jPanelDeviceNumber.setVisible(false);
        jPanelActivation.setVisible(false);
        jPanelLogConfigure.setVisible(false);
        jPanelLogPath.setVisible(false);
        jButtonGet.setEnabled(false);
        jButtonSet.setEnabled(false);

        // Switch selected Parameter and show/hide, enable/disable needed UI
        switch (selectedParameter)
        {
            case PCAN_DEVICE_NUMBER:
                // Verify Channel is USB device
                if (TPCANHandle.isPCANUSBHardware(getSelectedConnectedChannel()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelDeviceNumber.setVisible(true);
                break;
            case PCAN_5VOLTS_POWER:
                // Verify Channel is USB or PC-Card  device
                if (TPCANHandle.isPCANUSBHardware(getSelectedConnectedChannel()) || TPCANHandle.isPCANPCCardHardware(getSelectedConnectedChannel()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_API_VERSION:
                jButtonGet.setEnabled(true);
                break;
            case PCAN_CHANNEL_VERSION:
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS)
                    jButtonGet.setEnabled(true);
                break;
            case PCAN_BUSOFF_AUTORESET:
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS)
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LISTEN_ONLY:
                // Verify Channel contains SJA1000 microcontroller
                if (getSelectedConnectedChannel() != TPCANHandle.PCAN_NONEBUS && TPCANHandle.containsSJA(getSelectedConnectedChannel(), getSelectedChannelItem().getType()))
                {
                    jButtonSet.setEnabled(true);
                    jButtonGet.setEnabled(true);
                }
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LOG_LOCATION:
                if (jTextAreaPath.getText().length() > 0)
                    jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelLogPath.setVisible(true);
                break;
            case PCAN_LOG_STATUS:
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelActivation.setVisible(true);
                break;
            case PCAN_LOG_CONFIGURE:
                jButtonSet.setEnabled(true);
                jButtonGet.setEnabled(true);
                jPanelLogConfigure.setVisible(true);
                break;
            case PCAN_CHANNEL_CONDITION:
                jButtonGet.setEnabled(true);
                break;
        }
    }//GEN-LAST:event_jComboBoxParameterActionPerformed

    private void jButtonGetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonGetActionPerformed
    {//GEN-HEADEREND:event_jButtonGetActionPerformed
        // Prepare variables
        TPCANStatus status = null;
        StringBuffer buffer = new StringBuffer("");
        MutableInteger integerBuffer = new MutableInteger(0);
        String message = "";

        // Switch on selected Parameter
        switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
        {
            case PCAN_DEVICE_NUMBER:
            case PCAN_5VOLTS_POWER:
            case PCAN_BUSOFF_AUTORESET:
            case PCAN_LISTEN_ONLY:
            case PCAN_LOG_STATUS:
                // Retrieves information from a PCAN Channel in numeric form.
                status = pcanBasic.GetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_API_VERSION:
            case PCAN_CHANNEL_VERSION:
            case PCAN_LOG_LOCATION:
                // Retrieves information from a PCAN Channel in text form.
                status = pcanBasic.GetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, 256);
                break;
            case PCAN_LOG_CONFIGURE:
                // Retrieves information from a PCAN Channel in numeric form using Default channel Only.
                status = pcanBasic.GetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_CHANNEL_CONDITION:
                // Retrieves information from a PCAN Channel in numeric form using non initialized channel.
                status = pcanBasic.GetValue(getSelectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
        }

        // Process Result
        if (status == TPCANStatus.PCAN_ERROR_OK)
            switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
            {
                case PCAN_DEVICE_NUMBER:
                    showInfo("USB Device Number is: " + integerBuffer, false);
                    break;
                case PCAN_5VOLTS_POWER:
                    showInfo("The external 5V is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_API_VERSION:
                    showInfo("The PCAN-Basic API implementation version is: " + buffer, false);
                    break;
                case PCAN_CHANNEL_VERSION:
                    showInfo("The Driver of " + getSelectedConnectedChannel() + " is: " + buffer, false);
                    break;
                case PCAN_BUSOFF_AUTORESET:
                    showInfo("The PCAN_BUSOFF_AUTORESET parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LISTEN_ONLY:
                    showInfo("The PCAN_LISTEN_ONLY parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LOG_LOCATION:
                    showInfo("The Log File Path is: " + buffer, false);
                    break;
                case PCAN_LOG_STATUS:
                    showInfo("The PCAN_LOG_STATUS parameter is: " + TPCANParameterValue.parseOnOff(integerBuffer.getValue()), false);
                    break;
                case PCAN_LOG_CONFIGURE:
                    message = "Debug informations include:";
                    // Process included information in Log using Parameter values
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue()) == TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue())
                        message += "\nLOG_FUNCTION_ENTRY";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue()) == TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue())
                        message += "\nLOG_FUNCTION_LEAVE";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue()) == TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue())
                        message += "\nLOG_FUNCTION_PARAMETERS";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_READ.getValue()) == TPCANParameterValue.LOG_FUNCTION_READ.getValue())
                        message += "\nLOG_FUNCTION_READ";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_WRITE.getValue()) == TPCANParameterValue.LOG_FUNCTION_WRITE.getValue())
                        message += "\nLOG_FUNCTION_WRITE";
                    if (integerBuffer.value == 0)
                        message += "\nLOG_FUNCTION_DEFAULT";
                    showInfo(message, false);
                    break;
                case PCAN_CHANNEL_CONDITION:
                    showInfo("The PCAN_CHANNEL_CONDITION parameter is: " + TPCANParameterValue.parseCondition(integerBuffer.getValue()), false);
                    break;
            }
        else
            // Process Error
            getError(status);
    }//GEN-LAST:event_jButtonGetActionPerformed

    private void jButtonSetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonSetActionPerformed
    {//GEN-HEADEREND:event_jButtonSetActionPerformed
        // Prepare variables
        TPCANStatus status = null;
        StringBuffer buffer = new StringBuffer("");
        MutableInteger integerBuffer = new MutableInteger(0);
        String message = "";

        // Switch on selected Parameter
        switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
        {
            case PCAN_DEVICE_NUMBER:
                // Gets selected device number in parameter
                integerBuffer = new MutableInteger(jSpinnerDeviceNumber.getValue().toString());
                // Sets a configuration or information numeric value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_5VOLTS_POWER:
            case PCAN_BUSOFF_AUTORESET:
            case PCAN_LISTEN_ONLY:
                // Gets selected activation value(ON||OFF) in paramater
                integerBuffer = new MutableInteger(getSelectedActivationValue().getValue());
                // Sets a configuration or information numeric value within a PCAN Channel.
                status = pcanBasic.SetValue(getSelectedConnectedChannel(), (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_LOG_LOCATION:
                // Gets File Path Location in StringBuffer
                buffer.append(jTextAreaPath.getText());
                // Sets a configuration or information string value within a PCAN Channel.
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), buffer, 256);
                break;
            case PCAN_LOG_STATUS:
                // Gets selected activation value(ON||OFF) in paramater
                integerBuffer = new MutableInteger(getSelectedActivationValue().getValue());
                // Sets a configuration or information numeric value within the Default channel.
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
            case PCAN_LOG_CONFIGURE:
                // Prepares selected log information type in the parameter
                if (jCheckBoxEntry.isSelected())
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue();
                if (jCheckBoxLeave.isSelected())
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue();
                if (jCheckBoxParameter.isSelected())
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue();
                if (jCheckBoxRead.isSelected())
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_READ.getValue();
                if (jCheckBoxWrite.isSelected())
                    integerBuffer.value = integerBuffer.value | TPCANParameterValue.LOG_FUNCTION_WRITE.getValue();
                status = pcanBasic.SetValue(TPCANHandle.PCAN_NONEBUS, (TPCANParameter) jComboBoxParameter.getSelectedItem(), integerBuffer, Integer.SIZE);
                break;
        }

        // Process Result
        if (status == TPCANStatus.PCAN_ERROR_OK)
            switch ((TPCANParameter) jComboBoxParameter.getSelectedItem())
            {
                case PCAN_DEVICE_NUMBER:
                    showInfo("USB Device Number was successfully changed to: " + integerBuffer, false);
                    break;
                case PCAN_5VOLTS_POWER:
                    showInfo("The external 5V was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_BUSOFF_AUTORESET:
                    showInfo("The PCAN_BUSOFF_AUTORESET parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LISTEN_ONLY:
                    showInfo("The PCAN_LISTEN_ONLY parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LOG_LOCATION:
                    showInfo("The Log File Path  was successfully configured to: " + buffer, false);
                    break;
                case PCAN_LOG_STATUS:
                    showInfo("The PCAN_LOG_STATUS parameter was successfully configured to: " + getSelectedActivationValue(), false);
                    break;
                case PCAN_LOG_CONFIGURE:
                    message = "Now, debug informations will include:";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue()) == TPCANParameterValue.LOG_FUNCTION_ENTRY.getValue())
                        message += "\nLOG_FUNCTION_ENTRY";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue()) == TPCANParameterValue.LOG_FUNCTION_LEAVE.getValue())
                        message += "\nLOG_FUNCTION_LEAVE";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue()) == TPCANParameterValue.LOG_FUNCTION_PARAMETERS.getValue())
                        message += "\nLOG_FUNCTION_PARAMETERS";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_READ.getValue()) == TPCANParameterValue.LOG_FUNCTION_READ.getValue())
                        message += "\nLOG_FUNCTION_READ";
                    if ((integerBuffer.getValue() & TPCANParameterValue.LOG_FUNCTION_WRITE.getValue()) == TPCANParameterValue.LOG_FUNCTION_WRITE.getValue())
                        message += "\nLOG_FUNCTION_WRITE";
                    if (integerBuffer.value == 0)
                        message += "\nLOG_FUNCTION_DEFAULT";
                    showInfo(message, false);
                    break;
            }
        else
            // Process Error
            getError(status);
    }//GEN-LAST:event_jButtonSetActionPerformed

    private void jButtonBrowseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonBrowseActionPerformed
    {//GEN-HEADEREND:event_jButtonBrowseActionPerformed
        // Shows File Chooser in order to selecte log file path
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        // If user clicks "Select", gets selected file path
        if (JFileChooser.APPROVE_OPTION == chooser.showDialog(null, "Select"))
        {
            jTextAreaPath.setText(chooser.getSelectedFile().toString());
            if (jTextAreaPath.getText().length() > 0)
                jButtonSet.setEnabled(true);
        }
    }//GEN-LAST:event_jButtonBrowseActionPerformed

    private void jTextFieldWriteIDFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldWriteIDFocusLost
    {//GEN-HEADEREND:event_jTextFieldWriteIDFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxWriteExtended.isSelected());
}//GEN-LAST:event_jTextFieldWriteIDFocusLost

    private void jTextFieldWriteIDKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldWriteIDKeyTyped
    {//GEN-HEADEREND:event_jTextFieldWriteIDKeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldWriteIDKeyTyped

    private void jSpinnerLengthStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_jSpinnerLengthStateChanged
    {//GEN-HEADEREND:event_jSpinnerLengthStateChanged
        int selectedLength;
        selectedLength = (Integer) jSpinnerLength.getValue() - 1;

        // Enable or disable txtData regarding selected length
        jTextFieldData0.setEnabled((selectedLength >= 0) ? true : false);
        jTextFieldData1.setEnabled((selectedLength >= 1) ? true : false);
        jTextFieldData2.setEnabled((selectedLength >= 2) ? true : false);
        jTextFieldData3.setEnabled((selectedLength >= 3) ? true : false);
        jTextFieldData4.setEnabled((selectedLength >= 4) ? true : false);
        jTextFieldData5.setEnabled((selectedLength >= 5) ? true : false);
        jTextFieldData6.setEnabled((selectedLength >= 6) ? true : false);
        jTextFieldData7.setEnabled((selectedLength >= 7) ? true : false);
}//GEN-LAST:event_jSpinnerLengthStateChanged

    private void jTextFieldData0FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData0FocusLost
    {//GEN-HEADEREND:event_jTextFieldData0FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData0FocusLost

    private void jTextFieldData0KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData0KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData0KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData0KeyTyped

    private void jButtonWriteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonWriteActionPerformed
    {//GEN-HEADEREND:event_jButtonWriteActionPerformed
        TPCANMsg msgToSend;
        TPCANStatus status = null;
        int type = 0;

        // We create a TCLightMsg message structure
        msgToSend = new TPCANMsg();

        // We configurate the Message.  The ID (max 0x1FF),
        // Length of the Data, Message Type (Standard in
        // this example) and die data
        msgToSend.setID((int) hexTextToInt(jTextFieldWriteID.getText()));
        msgToSend.setLength(Byte.parseByte(jSpinnerLength.getValue().toString()));
        msgToSend.setType((jCheckBoxWriteExtended.isSelected()) ? TPCANMsg.MSGTYPE_EXTENDED : TPCANMsg.MSGTYPE_STANDARD);

        // If a remote frame will be sent, the data bytes are not important.
        if (jCheckBoxWriteRemote.isSelected())
        {
            type = msgToSend.getType() | TPCANMsg.MSGTYPE_RTR;
            msgToSend.setType((byte) type);
        }
        else
        {
            // We get so much data as the Len of the message
            if (msgToSend.getLength() >= 1)
                msgToSend.getData()[0] = (byte) hexTextToInt(jTextFieldData0.getText());
            if (msgToSend.getLength() >= 2)
                msgToSend.getData()[1] = (byte) hexTextToInt(jTextFieldData1.getText());
            if (msgToSend.getLength() >= 3)
                msgToSend.getData()[2] = (byte) hexTextToInt(jTextFieldData2.getText());
            if (msgToSend.getLength() >= 4)
                msgToSend.getData()[3] = (byte) hexTextToInt(jTextFieldData3.getText());
            if (msgToSend.getLength() >= 5)
                msgToSend.getData()[4] = (byte) hexTextToInt(jTextFieldData4.getText());
            if (msgToSend.getLength() >= 6)
                msgToSend.getData()[5] = (byte) hexTextToInt(jTextFieldData5.getText());
            if (msgToSend.getLength() >= 7)
                msgToSend.getData()[6] = (byte) hexTextToInt(jTextFieldData6.getText());
            if (msgToSend.getLength() >= 8)
                msgToSend.getData()[7] = (byte) hexTextToInt(jTextFieldData7.getText());
        }

        // The message is sent to the configured hardware
        status = pcanBasic.Write(getSelectedConnectedChannel(), msgToSend);

        // The Hardware was successfully sent
        if (status == TPCANStatus.PCAN_ERROR_OK)
                showInfo("Message was successfully SENT", false);
        // An error occurred.  We show the error.
        else
            getError(status);
}//GEN-LAST:event_jButtonWriteActionPerformed

    private void jCheckBoxWriteExtendedActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxWriteExtendedActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxWriteExtendedActionPerformed
        checkMessageID(jTextFieldWriteID, jCheckBoxWriteExtended.isSelected());
}//GEN-LAST:event_jCheckBoxWriteExtendedActionPerformed

    private void jCheckBoxWriteRemoteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxWriteRemoteActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxWriteRemoteActionPerformed
        boolean useTxtData = !jCheckBoxWriteRemote.isSelected();

        //Show or hide txtData depending it's a remote message
        jTextFieldData0.setVisible(useTxtData);
        jTextFieldData1.setVisible(useTxtData);
        jTextFieldData2.setVisible(useTxtData);
        jTextFieldData3.setVisible(useTxtData);
        jTextFieldData4.setVisible(useTxtData);
        jTextFieldData5.setVisible(useTxtData);
        jTextFieldData6.setVisible(useTxtData);
        jTextFieldData7.setVisible(useTxtData);
}//GEN-LAST:event_jCheckBoxWriteRemoteActionPerformed

    private void jTextFieldData1FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData1FocusLost
    {//GEN-HEADEREND:event_jTextFieldData1FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData1FocusLost

    private void jTextFieldData1KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData1KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData1KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData1KeyTyped

    private void jTextFieldData2FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData2FocusLost
    {//GEN-HEADEREND:event_jTextFieldData2FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData2FocusLost

    private void jTextFieldData2KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData2KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData2KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData2KeyTyped

    private void jTextFieldData3FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData3FocusLost
    {//GEN-HEADEREND:event_jTextFieldData3FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData3FocusLost

    private void jTextFieldData3KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData3KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData3KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData3KeyTyped

    private void jTextFieldData4FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData4FocusLost
    {//GEN-HEADEREND:event_jTextFieldData4FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData4FocusLost

    private void jTextFieldData4KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData4KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData4KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData4KeyTyped

    private void jTextFieldData5FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData5FocusLost
    {//GEN-HEADEREND:event_jTextFieldData5FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData5FocusLost

    private void jTextFieldData5KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData5KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData5KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData5KeyTyped

    private void jTextFieldData6FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData6FocusLost
    {//GEN-HEADEREND:event_jTextFieldData6FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData6FocusLost

    private void jTextFieldData6KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData6KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData6KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData6KeyTyped

    private void jTextFieldData7FocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldData7FocusLost
    {//GEN-HEADEREND:event_jTextFieldData7FocusLost
        checkDataBox((JTextField) evt.getComponent());
}//GEN-LAST:event_jTextFieldData7FocusLost

    private void jTextFieldData7KeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldData7KeyTyped
    {//GEN-HEADEREND:event_jTextFieldData7KeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldData7KeyTyped

    private void jTextFieldIDFromFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldIDFromFocusLost
    {//GEN-HEADEREND:event_jTextFieldIDFromFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxFilterExtended.isSelected());
}//GEN-LAST:event_jTextFieldIDFromFocusLost

    private void jTextFieldIDFromKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldIDFromKeyTyped
    {//GEN-HEADEREND:event_jTextFieldIDFromKeyTyped
        char chCheck;

        // We convert the Character to its Upper case equivalent
        chCheck = Character.toUpperCase(evt.getKeyChar());

        // The Key is the Delete (Backspace) Key
        if (chCheck == 8)
            return;
        // The Key is a number between 0-9
        if ((chCheck > 47) && (chCheck < 58))
            return;
        // The Key is a character between A-F
        if ((chCheck > 64) && (chCheck < 71))
            return;

        // Is neither a number nor a character between A(a) and F(f)
        evt.consume();
}//GEN-LAST:event_jTextFieldIDFromKeyTyped

    private void jTextFieldIDToFocusLost(java.awt.event.FocusEvent evt)//GEN-FIRST:event_jTextFieldIDToFocusLost
    {//GEN-HEADEREND:event_jTextFieldIDToFocusLost
        checkMessageID((JTextField) evt.getComponent(), jCheckBoxFilterExtended.isSelected());
}//GEN-LAST:event_jTextFieldIDToFocusLost

    private void jTextFieldIDToKeyTyped(java.awt.event.KeyEvent evt)//GEN-FIRST:event_jTextFieldIDToKeyTyped
    {//GEN-HEADEREND:event_jTextFieldIDToKeyTyped
        checkHex(evt);
}//GEN-LAST:event_jTextFieldIDToKeyTyped

    private void jButtonFilterSetActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFilterSetActionPerformed
    {//GEN-HEADEREND:event_jButtonFilterSetActionPerformed
        MutableInteger intBuffer = new MutableInteger(0);
        TPCANStatus status;

        // Gets the current status of the message filter
        if (!GetFilterStatus(intBuffer))
            return;

        // Configures the message filter for a custom range of messages
        if (jRadioFilterCustom.isSelected())
        {
            // The filter must be first closed in order to customize it
            if (intBuffer.value != TPCANParameterValue.PCAN_FILTER_OPEN.getValue())
            {
                // Sets the custom filter
                status = pcanBasic.FilterMessages(getSelectedConnectedChannel(),
                        (int) Long.parseLong(jTextFieldIDFrom.getText(), 16),
                        (int) Long.parseLong(jTextFieldIDTo.getText(), 16),
                        jCheckBoxFilterExtended.isSelected() ? TPCANMode.PCAN_MODE_EXTENDED : TPCANMode.PCAN_MODE_STANDARD);
                // If success, an information message is written, if it is not, an error message is shown
                if (status == TPCANStatus.PCAN_ERROR_OK)
                    showInfo("The filter was customized. IDs from " + jTextFieldIDFrom.getText() + " to " + jTextFieldIDTo.getText(), false);
                else
                    getError(status);
            }
            else
                showInfo("The filter must be closed first in order to be able to customize it", true);

            return;
        }

        // The filter will be full opened or complete closed
        if (jRadioFilterClose.isSelected())
            intBuffer = new MutableInteger(TPCANParameterValue.PCAN_FILTER_CLOSE.getValue());
        else
            intBuffer = new MutableInteger(TPCANParameterValue.PCAN_FILTER_OPEN.getValue());

        // The filter is configured
        status = pcanBasic.SetValue(getSelectedConnectedChannel(),TPCANParameter.PCAN_MESSAGE_FILTER,intBuffer,Integer.SIZE);

        // If success, an information message is written, if it is not, an error message is shown
        if (status == TPCANStatus.PCAN_ERROR_OK)
            if (jRadioFilterClose.isSelected())
                showInfo("The filter was successfully closed", false);
            else
                showInfo("The filter was successfully opened", false);
        else
            getError(status);

}//GEN-LAST:event_jButtonFilterSetActionPerformed

    private void jCheckBoxFilterExtendedActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxFilterExtendedActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxFilterExtendedActionPerformed
        checkMessageID(jTextFieldIDFrom, jCheckBoxFilterExtended.isSelected());
        checkMessageID(jTextFieldIDTo, jCheckBoxFilterExtended.isSelected());
    }//GEN-LAST:event_jCheckBoxFilterExtendedActionPerformed

    private void jButtonFilterQueryActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonFilterQueryActionPerformed
    {//GEN-HEADEREND:event_jButtonFilterQueryActionPerformed
        MutableInteger integerBuffer = new MutableInteger(0);

        // Queries the current status of the message filter
        if (GetFilterStatus(integerBuffer))
            switch (TPCANParameterValue.parseFilterStatus(integerBuffer.value))
            {
                // The filter is closed
                case PCAN_FILTER_CLOSE:
                    showInfo("The Status of the filter is: closed.", false);
                    break;
                // The filter is fully opened
                case PCAN_FILTER_OPEN:
                    showInfo("The Status of the filter is: full opened.", false);
                    break;
                // The filter is customized
                case PCAN_FILTER_CUSTOM:
                    showInfo("The Status of the filter is: customized.", false);
                    break;
                // The status of the filter is undefined. (Should never happen)
                default:
                    showInfo("The Status of the filter is: Invalid.", false);
                    break;
            }
    }//GEN-LAST:event_jButtonFilterQueryActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonCloseActionPerformed
    {//GEN-HEADEREND:event_jButtonCloseActionPerformed
        TPCANStatus status;

        // Stop Timer Thread
        if ((canReadThread != null) && (!canReadThread.isInterrupted()))
        {
            canReadThread.interrupt();
            try
            {
                canReadThread.join();
            }
            catch (InterruptedException ex)
            {
            }
        }

        // Unitializes each connected Channel
        for (ChannelItem subItem : connectedChannelCollection)
        {
            if (subItem != MarkAllChannelItem.getInstance())
            {
                status = uninitialize(subItem);
                if (status != TPCANStatus.PCAN_ERROR_OK)
                    return;
            }
        }

        // Exit the application
        System.exit(0);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowClosing
    {//GEN-HEADEREND:event_formWindowClosing
        //Close App
        jButtonCloseActionPerformed(null);
    }//GEN-LAST:event_formWindowClosing

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupFilter;
    private javax.swing.ButtonGroup buttonGroupONOFF;
    private javax.swing.ButtonGroup buttonGroupOpenClose;
    private javax.swing.ButtonGroup buttonGroupReadMode;
    private javax.swing.JButton jButtonBrowse;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonConnect;
    private javax.swing.JButton jButtonFilterQuery;
    private javax.swing.JButton jButtonFilterSet;
    private javax.swing.JButton jButtonGet;
    private javax.swing.JButton jButtonPause;
    private javax.swing.JButton jButtonRelease;
    private javax.swing.JButton jButtonSet;
    private javax.swing.JButton jButtonStart;
    private javax.swing.JButton jButtonWrite;
    private javax.swing.JCheckBox jCheckBoxEntry;
    private javax.swing.JCheckBox jCheckBoxFilterExtended;
    private javax.swing.JCheckBox jCheckBoxLeave;
    private javax.swing.JCheckBox jCheckBoxParameter;
    private javax.swing.JCheckBox jCheckBoxRead;
    private javax.swing.JCheckBox jCheckBoxTimeStamp;
    private javax.swing.JCheckBox jCheckBoxWrite;
    private javax.swing.JCheckBox jCheckBoxWriteExtended;
    private javax.swing.JCheckBox jCheckBoxWriteRemote;
    private javax.swing.JComboBox jComboBoxBaudrate;
    private javax.swing.JComboBox jComboBoxChannel;
    private javax.swing.JComboBox jComboBoxConnectedChannel;
    private javax.swing.JComboBox jComboBoxHardwareType;
    private javax.swing.JComboBox jComboBoxInterrupt;
    private javax.swing.JComboBox jComboBoxParameter;
    private javax.swing.JComboBox jComboBoxPort;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel61;
    private javax.swing.JLabel jLabel62;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLayeredPane jLayeredPaneConfiguration;
    private javax.swing.JPanel jPanelActivation;
    private javax.swing.JPanel jPanelConfiguration;
    private javax.swing.JPanel jPanelDeviceNumber;
    private javax.swing.JPanel jPanelFilter;
    private javax.swing.JPanel jPanelHardware;
    private javax.swing.JPanel jPanelInfo;
    private javax.swing.JPanel jPanelLogConfigure;
    private javax.swing.JPanel jPanelLogPath;
    private javax.swing.JPanel jPanelNewConnection;
    private javax.swing.JPanel jPanelRead;
    private javax.swing.JPanel jPanelWrite;
    private javax.swing.JRadioButton jRadioButtonEvent;
    private javax.swing.JRadioButton jRadioButtonOFF;
    private javax.swing.JRadioButton jRadioButtonON;
    private javax.swing.JRadioButton jRadioButtonTimer;
    private javax.swing.JRadioButton jRadioFilterClose;
    private javax.swing.JRadioButton jRadioFilterCustom;
    private javax.swing.JRadioButton jRadioFilterOpen;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPaneInfo;
    private javax.swing.JScrollPane jScrollPaneParameterDescription;
    private javax.swing.JScrollPane jScrollPanePath;
    private javax.swing.JSpinner jSpinnerDeviceNumber;
    private javax.swing.JSpinner jSpinnerLength;
    private javax.swing.JTable jTableMessage;
    private javax.swing.JTextArea jTextAreaParameterDescription;
    private javax.swing.JTextArea jTextAreaPath;
    private javax.swing.JTextField jTextFieldData0;
    private javax.swing.JTextField jTextFieldData1;
    private javax.swing.JTextField jTextFieldData2;
    private javax.swing.JTextField jTextFieldData3;
    private javax.swing.JTextField jTextFieldData4;
    private javax.swing.JTextField jTextFieldData5;
    private javax.swing.JTextField jTextFieldData6;
    private javax.swing.JTextField jTextFieldData7;
    private javax.swing.JTextField jTextFieldIDFrom;
    private javax.swing.JTextField jTextFieldIDTo;
    private javax.swing.JTextField jTextFieldWriteID;
    private javax.swing.JTextArea jTexteAreaInfo;
    // End of variables declaration//GEN-END:variables
    // Static Token For Synchronization
    static public final Object token = new Object();
    // PCANBasic instance
    PCANBasic pcanBasic = null;
    // Collection containing connected channels
    Vector<ChannelItem> connectedChannelCollection = null;
    // Configured language
    short languageIndex = 0;
    // Thread to read CAN messages
    CANReadThread canReadThread;
    // Thread to refresh data grid
    TableMessageThread tableMessageThread;
    // Map to store received messages
    private HashMap receivedData = new HashMap();
    // Grid column to show TimeStamp
    private TableColumn columnTimeStamp = null;

    // Returns selected TPCANBaudrate
    private TPCANBaudrate getSelectedBaudrate()
    {
        return (TPCANBaudrate) jComboBoxBaudrate.getSelectedItem();
    }

    // Returns selected non-connected TPCANHandle
    private TPCANHandle getSelectedChannel()
    {
        return (TPCANHandle) jComboBoxChannel.getSelectedItem();
    }

    // Returns selected TPCANType
    private TPCANType getSelectedHardwareType()
    {
        return (TPCANType) jComboBoxHardwareType.getSelectedItem();
    }

    // Returns selected port number
    private int getSelectedPort()
    {
        return new Integer(jComboBoxPort.getSelectedItem().toString());
    }

    // Returns selected connected TPCANHandle
    private TPCANHandle getSelectedConnectedChannel()
    {
        if (jComboBoxConnectedChannel.getSelectedIndex() != -1)
            return ((ChannelItem) (jComboBoxConnectedChannel.getSelectedItem())).getHandle();
        else
            return TPCANHandle.PCAN_NONEBUS;
    }

    // Returns selected ChannelItem
    private ChannelItem getSelectedChannelItem()
    {
        if (jComboBoxConnectedChannel.getSelectedIndex() != -1)
            return (ChannelItem) (jComboBoxConnectedChannel.getSelectedItem());
        else
            return null;
    }

    // Returns selected interrupt value
    private short getSelectedInterrupt()
    {
        return new Short(jComboBoxInterrupt.getSelectedItem().toString());
    }

    // Returns selected activation value(ON||OFF)
    private TPCANParameterValue getSelectedActivationValue()
    {
        if (jRadioButtonON.isSelected())
            return TPCANParameterValue.PCAN_PARAMETER_ON;
        else
            return TPCANParameterValue.PCAN_PARAMETER_OFF;
    }

    // Process and Displays PCANBasic Error Message
    private void getError(TPCANStatus status)
    {
        StringBuffer error;

        // If Error
        if (status != TPCANStatus.PCAN_ERROR_OK)
        {
            error = new StringBuffer("");
            status = pcanBasic.GetErrorText(status, languageIndex, error);
            // Display Error
            if (status == TPCANStatus.PCAN_ERROR_OK)
                showInfo(error.toString(), true);
            // Unable To Retrieve Error
            else
                showInfo("Unable to call GetErrorText Function !", true);
        }
    }

    // Displays Info Message
    private void showInfo(String text, boolean error)
    {
        // If it's an error message, configure foreground in red
        if (error)
            jTexteAreaInfo.setForeground(new java.awt.Color(255, 0, 0));
        // Else configure foreground in black
        else
            jTexteAreaInfo.setForeground(new java.awt.Color(0, 0, 0));
        // Update txtInfo box
        jTexteAreaInfo.setText(text);
    }

    // Changes the read method function
    private void changeReadMode(boolean useTimerMode)
    {
        TPCANStatus status;
        StringBuffer error;

        // Stop Timer Thread
        if ((canReadThread != null) && (!canReadThread.isInterrupted()))
        {
            canReadThread.interrupt();
            try
            {
                canReadThread.join();
            }
            catch (InterruptedException ex)
            {
            }
        }

        // Create New CANReadThread with default values
        canReadThread = new CANReadThread(pcanBasic, connectedChannelCollection, receivedData);
        canReadThread.setReadTimeStamp(jCheckBoxTimeStamp.isSelected());
        if (useTimerMode)
        {
            // Iterate All Connected Channels
            for (ChannelItem channel : connectedChannelCollection)
            {
                // If isWorking, call SetRcvEvent on current channel
                if (channel.getWorking())
                {
                    status = pcanBasic.ResetRcvEvent(channel.getHandle());
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                        getError(status);
                }
            }

            // Start Timer Thread to read CAN Messages
            canReadThread.start();
        }
        else
        {
            // Set canReadThread as RcvEvent Listener
            RcvEventDispatcher.setListener(canReadThread);

            // Iterate All Connected Channels
            for (ChannelItem channel : connectedChannelCollection)
            {
                // If isWorking, call SetRcvEvent on current channel
                if (channel.getWorking())
                {
                    status = pcanBasic.SetRcvEvent(channel.getHandle());
                    if (status != TPCANStatus.PCAN_ERROR_OK)
                        getError(status);
                }
            }
        }
    }

    // Changes Channel state in order to pass from pause to working and inverssely
    private void changeChannelState(ChannelItem item, boolean workingState)
    {
        TPCANStatus status;
        StringBuffer error;

        // Configure ChannelItem
        item.setWorking(workingState);

        // If Read By Event Is Selected
        if (jRadioButtonEvent.isSelected())
        {
            // Call SetRcvEvent Function
            if (workingState)
                status = pcanBasic.SetRcvEvent(item.getHandle());
            else
                status = pcanBasic.ResetRcvEvent(item.getHandle());

            // If Error
            if (status != TPCANStatus.PCAN_ERROR_OK)
                getError(status);
        }
    }

    // Enables/disables UI depending of connected channel(s) in order to block or active Application features
    private void UpdateUIButtons()
    {
        // By default, disable main features(Write and Filter)
        jButtonWrite.setEnabled(false);
        jButtonFilterSet.setEnabled(false);
        jButtonFilterQuery.setEnabled(false);

        // If any channel is connected
        if (connectedChannelCollection.size() > 0)
        {
            // Enables Release button
            jButtonRelease.setEnabled(true);

            // Gets selected and connected ChannelItem
            ChannelItem item = (ChannelItem) jComboBoxConnectedChannel.getModel().getSelectedItem();

            // If it is a simple ChannelItem
            if (item != MarkAllChannelItem.getInstance())
            {
                jButtonPause.setEnabled(item.getWorking());
                jButtonStart.setEnabled(!item.getWorking());
                jButtonWrite.setEnabled(true);
                jButtonFilterSet.setEnabled(true);
                jButtonFilterQuery.setEnabled(true);
            }
            // Else it is the MarkAllChannelItem
            else
            {
                boolean containsWorkingChannels = false;
                boolean containsStoppedChannels = false;
                for (ChannelItem channel : connectedChannelCollection)
                {
                    if (channel == MarkAllChannelItem.getInstance())
                        continue;
                    if (channel.getWorking())
                        containsWorkingChannels = true;
                    else
                        containsStoppedChannels = true;
                }
                jButtonPause.setEnabled(containsWorkingChannels);
                jButtonStart.setEnabled(containsStoppedChannels);
            }
        }
        // No channel connected
        else
        {
            jButtonStart.setEnabled(false);
            jButtonPause.setEnabled(false);
            jButtonRelease.setEnabled(false);
        }

        // Update Parameter Panel
        jComboBoxParameterActionPerformed(null);
    }

    // Unitializes Channel using ChannelItem
    private TPCANStatus uninitialize(ChannelItem item)
    {
        TPCANStatus status;
        // Sets Channel in pause if need be
        if (item.getWorking())
            changeChannelState(item, false);
        // Releases the connected PCAN-Basic channel
        status = pcanBasic.Uninitialize(item.getHandle());

        // Process Result
        if (status != TPCANStatus.PCAN_ERROR_OK)
            getError(status);
        return status;
    }

    // Checks typed key is an hexadecimal character
    private void checkHex(java.awt.event.KeyEvent evt)
    {
        char chCheck;

        // We convert the Character to its Upper case equivalent
        chCheck = Character.toUpperCase(evt.getKeyChar());

        // The Key is the Delete (Backspace) Key
        if (chCheck == 8)
            return;
        // The Key is a number between 0-9
        if ((chCheck > 47) && (chCheck < 58))
            return;
        // The Key is a character between A-F
        if ((chCheck > 64) && (chCheck < 71))
            return;

        // Is neither a number nor a character between A(a) and F(f)
        evt.consume();
    }

    // Checks current Data Box contains valid values
    private void checkDataBox(JTextField IdBox)
    {
        int MaxValue;

        // Set To Upper Case
        IdBox.setText(IdBox.getText().toUpperCase());

        // We verify number of characters
        if (IdBox.getText().length() > 2)
            IdBox.setText(IdBox.getText().substring(0, 2));

        // calculate the text length and Maximum ID value according
        // with the Message Type
        MaxValue = (int) 0x7FF;

        // The Textbox for the ID is represented with 3 characters for
        // Standard and 8 characters for extended messages.
        // Therefore if the Length of the text is smaller than TextLength,
        // we add "0"
        while (IdBox.getText().length() != 2)
        {
            IdBox.setText("0" + IdBox.getText());
        }

        // Because in this example will be sent only Standard messages
        // we check that the ID is not bigger than 0x7FF
        if (Integer.parseInt(IdBox.getText(), 16) > MaxValue)
            IdBox.setText("7FF");

    }
    // Checks JTextField hexadecimal content

    private void checkMessageID(JTextField IdBox, boolean isExtended)
    {
        int TextLength;
        int MaxValue;
        int maxLength = 3;

        // Set To Upper Case
        IdBox.setText(IdBox.getText().toUpperCase());

        // We verify number of characters
        if (isExtended)
            maxLength = 8;
        if (IdBox.getText().length() > maxLength)
            IdBox.setText(IdBox.getText().substring(0, maxLength));

        // calculate the text length and Maximum ID value according
        // with the Message Type
        TextLength = (isExtended) ? 8 : 3;
        MaxValue = (isExtended) ? (int) 0x1FFFFFFF : (int) 0x7FF;

        // The Textbox for the ID is represented with 3 characters for
        // Standard and 8 characters for extended messages.
        // Therefore if the Length of the text is smaller than TextLength,
        // we add "0"
        while (IdBox.getText().length() != TextLength)
        {
            IdBox.setText("0" + IdBox.getText());
        }

        // Because in this example will be sent only Standard messages
        // we check that the ID is not bigger than 0x7FF
        if (Long.parseLong(IdBox.getText(), 16) > MaxValue)
            if (isExtended)
                IdBox.setText("1FFFFFFF");
            else
                IdBox.setText("7FF");
    }

    // Converts a string to hex
    static long hexTextToInt(String toConvert)
    {
        long iToReturn = 0;
        int iExp = 0;
        char chByte;

        // The string to convert is empty
        if (toConvert.equals(""))
            return 0;
        // The string have more than 8 character (the equivalent value
        // exeeds the DWORD capacyty
        if (toConvert.length() > 8)
            return 0;
        // We convert any character to its Upper case
        toConvert = toConvert.toUpperCase();
        try
        {
            // We calculate the number using the Hex To Decimal formula
            for (int i = toConvert.length() - 1; i >= 0; i--)
            {
                chByte = (char) toConvert.getBytes()[i];
                switch ((int) chByte)
                {
                    case 65:
                        iToReturn += (long) (10 * Math.pow(16.0f, iExp));
                        break;
                    case 66:
                        iToReturn += (long) (11 * Math.pow(16.0f, iExp));
                        break;
                    case 67:
                        iToReturn += (long) (12 * Math.pow(16.0f, iExp));
                        break;
                    case 68:
                        iToReturn += (long) (13 * Math.pow(16.0f, iExp));
                        break;
                    case 69:
                        iToReturn += (long) (14 * Math.pow(16.0f, iExp));
                        break;
                    case 70:
                        iToReturn += (long) (15 * Math.pow(16.0f, iExp));
                        break;
                    default:
                        if ((chByte < 48) || (chByte > 57))
                            return -1;
                        iToReturn += (long) Integer.parseInt(((Character) chByte).toString()) * Math.pow(16.0f, iExp);
                        break;
                }
                iExp++;
            }
        }
        catch (Exception ex)
        {
            // Error, return 0
            return 0;
        }
        return iToReturn;
    }

    // Gets the current status of the PCAN-Basic message filter
    private boolean GetFilterStatus(MutableInteger filterStatus)
    {
        TPCANStatus status;

        // Tries to get the status of the filter for the current connected hardware
        status = pcanBasic.GetValue(getSelectedConnectedChannel(), TPCANParameter.PCAN_MESSAGE_FILTER, filterStatus, Integer.SIZE);

        // If it fails, a error message is shown
        if (status != TPCANStatus.PCAN_ERROR_OK)
        {
            getError(status);
            return false;
        }
        return true;
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
        java.awt.EventQueue.invokeLater(new Runnable()
        {

            public void run()
            {
                new Application().setVisible(true);
            }
        });
    }
}
