/*
 * Decompiled with CFR 0.152.
 */
package peak.can.basic;

import java.util.Stack;
import peak.can.basic.TPCANType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TPCANHandle {
    PCAN_NONEBUS(0),
    PCAN_ISABUS1(33),
    PCAN_ISABUS2(34),
    PCAN_ISABUS3(35),
    PCAN_ISABUS4(36),
    PCAN_ISABUS5(37),
    PCAN_ISABUS6(38),
    PCAN_ISABUS7(39),
    PCAN_ISABUS8(40),
    PCAN_DNGBUS1(49),
    PCAN_PCIBUS1(65),
    PCAN_PCIBUS2(66),
    PCAN_PCIBUS3(67),
    PCAN_PCIBUS4(68),
    PCAN_PCIBUS5(69),
    PCAN_PCIBUS6(70),
    PCAN_PCIBUS7(71),
    PCAN_PCIBUS8(72),
    PCAN_USBBUS1(81),
    PCAN_USBBUS2(82),
    PCAN_USBBUS3(83),
    PCAN_USBBUS4(84),
    PCAN_USBBUS5(85),
    PCAN_USBBUS6(86),
    PCAN_USBBUS7(87),
    PCAN_USBBUS8(88),
    PCAN_PCCBUS1(97),
    PCAN_PCCBUS2(98);

    private final byte value;

    private TPCANHandle(byte value) {
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public static Object[] initializableChannels() {
        Stack<TPCANHandle> result = new Stack<TPCANHandle>();
        for (int i = 1; i < TPCANHandle.values().length; ++i) {
            result.add(TPCANHandle.values()[i]);
        }
        return result.toArray();
    }

    public static boolean isPCANUSBHardware(TPCANHandle handle) {
        switch (handle) {
            case PCAN_USBBUS1: 
            case PCAN_USBBUS2: 
            case PCAN_USBBUS3: 
            case PCAN_USBBUS4: 
            case PCAN_USBBUS5: 
            case PCAN_USBBUS6: 
            case PCAN_USBBUS7: 
            case PCAN_USBBUS8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPCANPCCardHardware(TPCANHandle handle) {
        switch (handle) {
            case PCAN_PCCBUS1: 
            case PCAN_PCCBUS2: {
                return true;
            }
        }
        return false;
    }

    public static boolean containsSJA(TPCANHandle handle, TPCANType type) {
        switch (handle) {
            case PCAN_DNGBUS1: 
            case PCAN_ISABUS1: 
            case PCAN_ISABUS2: 
            case PCAN_ISABUS3: 
            case PCAN_ISABUS4: 
            case PCAN_ISABUS5: 
            case PCAN_ISABUS6: 
            case PCAN_ISABUS7: 
            case PCAN_ISABUS8: {
                switch (type) {
                    case PCAN_TYPE_DNG_SJA: 
                    case PCAN_TYPE_DNG_SJA_EPP: 
                    case PCAN_TYPE_ISA_SJA: {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

