/*
 * Decompiled with CFR 0.152.
 */
package peak.can;

import java.util.HashMap;
import java.util.Vector;
import peak.can.Application;
import peak.can.ChannelItem;
import peak.can.MarkAllChannelItem;
import peak.can.TableDataRow;
import peak.can.basic.IRcvEventProcessor;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANStatus;
import peak.can.basic.TPCANTimestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CANReadThread
extends Thread
implements IRcvEventProcessor {
    private PCANBasic pcanBasic;
    private Vector<ChannelItem> connectedChannelCollection = null;
    private HashMap dataRowCollection;
    private Boolean readTimeStamp = false;

    public Boolean getReadTimeStamp() {
        return this.readTimeStamp;
    }

    public void setReadTimeStamp(Boolean useReadEx) {
        this.readTimeStamp = useReadEx;
    }

    public CANReadThread(PCANBasic pcanbasic, Vector<ChannelItem> connectedChannelCollection, HashMap dataRowCollection) {
        this.pcanBasic = pcanbasic;
        this.dataRowCollection = dataRowCollection;
        this.connectedChannelCollection = connectedChannelCollection;
    }

    @Override
    public void run() {
        while (true) {
            for (ChannelItem item : this.connectedChannelCollection) {
                if (item == MarkAllChannelItem.getInstance() || !item.getWorking()) continue;
                this.callAPIFunctionRead(item.getHandle());
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAPIFunctionRead(TPCANHandle handle) {
        block7: {
            TPCANMsg canMessage = null;
            TPCANTimestamp rcvTime = null;
            TableDataRow dataRow = null;
            int messageID = 0;
            try {
                canMessage = new TPCANMsg();
                rcvTime = new TPCANTimestamp();
                TPCANStatus ret = this.readTimeStamp != false ? this.pcanBasic.Read(handle, canMessage, rcvTime) : this.pcanBasic.Read(handle, canMessage, null);
                if (ret != TPCANStatus.PCAN_ERROR_OK) break block7;
                messageID = canMessage.getID();
                dataRow = this.dataRowCollection.containsKey(messageID) ? (TableDataRow)this.dataRowCollection.get(messageID) : new TableDataRow();
                dataRow.setMessage(canMessage);
                if (this.readTimeStamp.booleanValue()) {
                    dataRow.setRcvTime(rcvTime);
                } else {
                    dataRow.setRcvTime(null);
                }
                dataRow.setCounter(dataRow.getCounter() + 1);
                Object object = Application.token;
                synchronized (object) {
                    this.dataRowCollection.put(messageID, dataRow);
                }
                canMessage = null;
                rcvTime = null;
            }
            catch (Exception e) {
                System.out.println("CANReadThread Exception:" + e.getMessage());
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    @Override
    public void processRcvEvent(TPCANHandle channel) {
        this.callAPIFunctionRead(channel);
    }
}

